package com.hero.objects.characteristics;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.DamageResistance;
import com.hero.objects.powers.Power;
import com.hero.objects.talents.CombatLuck;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class PhysicalDefense extends Characteristic {

	private static String xmlID = "PD";

	protected int pdResistance;

	protected long pdResistanceCalcTime;

	protected int primaryResistantTotal;

	protected long primaryResistantTotalCalcTime;

	protected int secondaryResistantTotal;

	protected long secondaryResistantTotalCalcTime;
	
	protected boolean isResistant;

	@Override
	protected void init(Element element) {
		super.init(element);
		String check = XMLUtility.getValue(element, "RESISTANT");
		if (check != null && check.trim().length() > 0 && check.toUpperCase().startsWith("Y")) {
			isResistant = true;
		} else {
			isResistant = false;
		}
	}

	public PhysicalDefense(Element template) {
		super(template, PhysicalDefense.xmlID);
	}

	@Override
	protected void calcBaseValue() {
		double bonus = 0;
		double automaton = 1;
		if (HeroDesigner.getActiveHero() != null) {
			if (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
					.getPowers(), "AUTOMATON") != null) {
				Automaton auto = (Automaton) GenericObject.findObjectByID(
						HeroDesigner.getActiveHero().getPowers(), "AUTOMATON");
				if (auto.getSelectedOption().getXMLID().toUpperCase()
						.startsWith("NOSTUN")) {
					automaton = auto.getBasePDEDDenomenator();
				}
			}
		}
		if (HeroDesigner.getActiveHero() != null) {
			baseLevel = origBaseLevel/automaton;
			doubleBase = origBaseLevel/automaton;
			for (int i = 0; i < HeroDesigner.getActiveHero()
					.getCharacteristics().size(); i++) {
				Characteristic ch = (Characteristic) HeroDesigner
						.getActiveHero().getCharacteristics().get(i);
				if (!ch.getXMLID().equals(getXMLID())
						&& ch.getIncreaseLevels(getType()) > 0
						&& ch.getIncrease(getType()) != 0
						&& CharAffectingObject.checkFigured(ch, getType())) {
					double val = ch.getCharacteristicValue()
							* ch.getIncrease(getType())
							/ ch.getIncreaseLevels(getType());
					if (!ch.getTypes().contains("DEFENSE")) {
						val = val / automaton;
					}
					doubleBase += val;
					bonus += Rounder.roundHalfUp(val);
				}
			}
			for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
				if (HeroDesigner.getActiveHero().getPowers().get(i).getXMLID()
						.equals(getXMLID())) {
					continue;
				} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
					CompoundPower cp = (CompoundPower) HeroDesigner
							.getActiveHero().getPowers().get(i);
					for (int j = 0; j < cp.getPowers().size(); j++) {
						if (cp.getPowers().get(j).getXMLID().equals(getXMLID())) {
							continue;
						} else if (cp.getPowers().get(j) instanceof Characteristic) {
							CharAffectingObject power = (CharAffectingObject) cp
									.getPowers().get(j);
							if (power.getIncreaseLevels(getType()) > 0
									&& power.getIncrease(getType()) != 0) {
								if (power.getAffectPrimary()
										&& CharAffectingObject.checkFigured(
												power, getType())
										&& power.getAffectTotal()) {
									double mult = power.getIncreaseValue(
											getType(), true);
									doubleBase += mult / automaton;
									bonus += Rounder.roundHalfUp(mult
											/ automaton);
								}
							}
						}
					}
				} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof Characteristic) {
					CharAffectingObject power = (CharAffectingObject) HeroDesigner
							.getActiveHero().getPowers().get(i);
					if (power.getIncreaseLevels(getType()) > 0
							&& power.getIncrease(getType()) != 0) {
						if (power.getAffectPrimary()
								&& CharAffectingObject.checkFigured(power,
										getType()) && power.getAffectTotal()) {
							double mult = power.getIncreaseValue(getType(),
									true);
							doubleBase += mult / automaton;
							bonus += Rounder.roundHalfUp(mult / automaton);
						}
					}
				}
			}
			for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment()
					.size(); i++) {
				if (HeroDesigner.getActiveHero().getEquipment().get(i)
						.getXMLID().equals(getXMLID())) {
					continue;
				} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
					CompoundPower cp = (CompoundPower) HeroDesigner
							.getActiveHero().getEquipment().get(i);
					for (int j = 0; j < cp.getPowers().size(); j++) {
						if (cp.getPowers().get(j).getXMLID().equals(getXMLID())) {
							continue;
						} else if (cp.getPowers().get(j) instanceof Characteristic) {
							CharAffectingObject power = (CharAffectingObject) cp
									.getPowers().get(j);
							if (power.getIncreaseLevels(getType()) > 0
									&& power.getIncrease(getType()) != 0) {
								if (power.getAffectPrimary()
										&& CharAffectingObject.checkFigured(
												power, getType())
										&& power.getAffectTotal()) {
									double mult = power.getIncreaseValue(
											getType(), true);
									doubleBase += mult / automaton;
									bonus += Rounder.roundHalfUp(mult
											/ automaton);
								}
							}
						}
					}
				} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof Characteristic) {
					CharAffectingObject power = (CharAffectingObject) HeroDesigner
							.getActiveHero().getEquipment().get(i);
					if (power.getIncreaseLevels(getType()) > 0
							&& power.getIncrease(getType()) != 0) {
						if (power.getAffectPrimary()
								&& CharAffectingObject.checkFigured(power,
										getType()) && power.getAffectTotal()) {
							double mult = power.getIncreaseValue(getType(),
									true);
							doubleBase += mult / automaton;
							bonus += Rounder.roundHalfUp(mult / automaton);
						}
					}
				}
			}
		}
		if (baseLevel + bonus < maxVal) {
			baseValue = baseLevel + bonus;
		} else {
			baseValue = maxVal;
		}

		baseValueCalcTime = System.currentTimeMillis();
	}

	protected void calcPdResistance() {
		int bonus = 0;
		if (isResistant) {
			bonus += getValue(isFigured(), getType());
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof DamageResistance) {
				DamageResistance power = (DamageResistance) HeroDesigner
						.getActiveHero().getPowers().get(i);
				bonus += power.getPdLevels();
			} else if (HeroDesigner.getActiveHero().getPowers().get(i)
					.getXMLID().equals(getXMLID())) {
				PhysicalDefense o = (PhysicalDefense)HeroDesigner.getActiveHero().getPowers().get(i);
				if (isResistant) {
					bonus += o.getLevels();
				}	
				else if (findObjectByID(o.getAssignedModifiers(), "RESISTANT") != null) {
					
					if (o.addModifiersToBase() && !isResistant) {
						bonus += getValue(isFigured(), getType());
					} 
					if (o.getAffectTotal()) {
						bonus += o.getLevels();
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof DamageResistance) {
						DamageResistance power = (DamageResistance) cp
								.getPowers().get(j);
						bonus += power.getPdLevels();
					} else if (cp.getPowers().get(j)
							.getXMLID().equals(getXMLID())) {
						PhysicalDefense o = (PhysicalDefense)cp.getPowers().get(j);
						if (isResistant) {
							bonus += o.getLevels();
						}	
						else if (findObjectByID(o.getAssignedModifiers(), "RESISTANT") != null) {
							if (o.addModifiersToBase() && !isResistant) {
								bonus += getValue(isFigured(), getType());
							} 
							if (o.getAffectTotal()) {
								bonus += o.getLevels();
							}
						}
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof DamageResistance) {
				DamageResistance power = (DamageResistance) HeroDesigner
						.getActiveHero().getEquipment().get(i);
				bonus += power.getPdLevels();
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i)
					.getXMLID().equals(getXMLID())) {
				PhysicalDefense o = (PhysicalDefense)HeroDesigner.getActiveHero().getEquipment().get(i);
				if (isResistant) {
					bonus += o.getLevels();
				}	
				else if (findObjectByID(o.getAssignedModifiers(), "RESISTANT") != null) {
					if (o.addModifiersToBase() && !isResistant) {
						bonus += getValue(isFigured(), getType());
					} 
					if (o.getAffectTotal()) {
						bonus += o.getLevels();
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof DamageResistance) {
						DamageResistance power = (DamageResistance) cp
								.getPowers().get(j);
						bonus += power.getPdLevels();
					} else if (cp.getPowers().get(j)
							.getXMLID().equals(getXMLID())) {
						PhysicalDefense o = (PhysicalDefense)cp.getPowers().get(j);
						if (isResistant) {
							bonus += o.getLevels();
						}	
						else if (findObjectByID(o.getAssignedModifiers(), "RESISTANT") != null) {
							if (o.addModifiersToBase() && !isResistant) {
								bonus += getValue(isFigured(), getType());
							} 
							if (o.getAffectTotal()) {
								bonus += o.getLevels();
							}
						}
					}
				}
			}
		}
		pdResistance = bonus;
		pdResistanceCalcTime = System.currentTimeMillis();
	}

	@Override
	protected void calcPrimaryValue() {
		double bonus = getCharacteristicValue();
		double automaton = 1;
		if (HeroDesigner.getActiveHero() != null) {
			if (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
					.getPowers(), "AUTOMATON") != null) {
				Automaton auto = (Automaton) GenericObject.findObjectByID(
						HeroDesigner.getActiveHero().getPowers(), "AUTOMATON");
				if (auto.getSelectedOption().getXMLID().toUpperCase()
						.startsWith("NOSTUN")) {
					automaton = auto.getBasePDEDDenomenator();
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if (HeroDesigner.getActiveHero().getPowers().get(i).getXMLID()
					.equals(getXMLID())) {
				Characteristic power = (Characteristic) HeroDesigner
						.getActiveHero().getPowers().get(i);
				if (power.getAffectPrimary() && power.getAffectTotal()) {
					bonus += power.getLevels();
					doubleBase += power.getLevels();
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j).getXMLID().equals(getXMLID())) {
						Characteristic power = (Characteristic) cp.getPowers()
								.get(j);
						if (power.getAffectPrimary() && power.getAffectTotal()) {
							bonus += power.getLevels();
							doubleBase += power.getLevels();
						}
					} else if (cp.getPowers().get(j) instanceof CombatLuck) {
						CombatLuck power = (CombatLuck) cp.getPowers().get(j);
						if (power.getPdIncreaseLevels() > 0) {
							if (power.getAffectPrimary()
									&& power.getAffectTotal()) {
								bonus += Rounder.roundHalfUp(power
										.getPdIncrease()
										* (double) power.getLevels()
										/ (double) power.getPdIncreaseLevels());
							}
						}
					} else if (cp.getPowers().get(j) instanceof CharAffectingObject
							&& !(cp.getPowers().get(j) instanceof Characteristic)) {
						CharAffectingObject power = (CharAffectingObject) cp
								.getPowers().get(j);
						if (power.getIncreaseLevels(getType()) > 0
								&& power.getIncrease(getType()) != 0) {
							if (power.getAffectPrimary()
									&& CharAffectingObject.checkFigured(power,
											getType())
									&& power.getAffectTotal()) {
								double mult = power.getIncreaseValue(getType(),
										true);
								doubleBase += mult; // / automaton;
								bonus += mult; // / automaton;
							}
						}
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CombatLuck) {
				CombatLuck power = (CombatLuck) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				if (power.getPdIncreaseLevels() > 0) {
					if (power.getAffectPrimary() && power.getAffectTotal()) {
						bonus += Rounder.roundHalfUp(power.getPdIncrease()
								* (double) power.getLevels()
								/ (double) power.getPdIncreaseLevels());
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CharAffectingObject
					&& !(HeroDesigner.getActiveHero().getPowers().get(i) instanceof Characteristic)) {
				CharAffectingObject power = (CharAffectingObject) HeroDesigner
						.getActiveHero().getPowers().get(i);
				if (power.getIncreaseLevels(getType()) > 0
						&& power.getIncrease(getType()) != 0) {
					if (power.getAffectPrimary()
							&& CharAffectingObject.checkFigured(power,
									getType()) && power.getAffectTotal()) {
						double mult = power.getIncreaseValue(getType(), true);
						doubleBase += mult; // / automaton;
						bonus += Rounder.roundHalfUp(mult); // / automaton);
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if (HeroDesigner.getActiveHero().getEquipment().get(i).getXMLID()
					.equals(getXMLID())) {
				Characteristic power = (Characteristic) HeroDesigner
						.getActiveHero().getEquipment().get(i);
				if (power.getAffectPrimary() && power.getAffectTotal()) {
					bonus += power.getLevels();
					doubleBase += power.getLevels();
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j).getXMLID().equals(getXMLID())) {
						Characteristic power = (Characteristic) cp.getPowers()
								.get(j);
						if (power.getAffectPrimary() && power.getAffectTotal()) {
							bonus += power.getLevels();
							doubleBase += power.getLevels();
						}
					} else if (cp.getPowers().get(j) instanceof CombatLuck) {
						CombatLuck power = (CombatLuck) cp.getPowers().get(j);
						if (power.getPdIncreaseLevels() > 0) {
							if (power.getAffectPrimary()
									&& power.getAffectTotal()) {
								bonus += Rounder.roundHalfUp(power
										.getPdIncrease()
										* (double) power.getLevels()
										/ (double) power.getPdIncreaseLevels());
							}
						}
					} else if (cp.getPowers().get(j) instanceof CharAffectingObject
							&& !(cp.getPowers().get(j) instanceof Characteristic)) {
						CharAffectingObject power = (CharAffectingObject) cp
								.getPowers().get(j);
						if (power.getIncreaseLevels(getType()) > 0
								&& power.getIncrease(getType()) != 0) {
							if (power.getAffectPrimary()
									&& CharAffectingObject.checkFigured(power,
											getType())
									&& power.getAffectTotal()) {
								double mult = power.getIncreaseValue(getType(),
										true);
								doubleBase += mult; // / automaton;
								bonus += Rounder.roundHalfUp(mult); // / automaton);
							}
						}
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CombatLuck) {
				CombatLuck power = (CombatLuck) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				if (power.getPdIncreaseLevels() > 0) {
					if (power.getAffectPrimary() && power.getAffectTotal()) {
						bonus += Rounder.roundHalfUp(power.getPdIncrease()
								* (double) power.getLevels()
								/ (double) power.getPdIncreaseLevels());
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CharAffectingObject
					&& !(HeroDesigner.getActiveHero().getEquipment().get(i) instanceof Characteristic)) {
				CharAffectingObject power = (CharAffectingObject) HeroDesigner
						.getActiveHero().getEquipment().get(i);
				if (power.getIncreaseLevels(getType()) > 0
						&& power.getIncrease(getType()) != 0) {
					if (power.getAffectPrimary()
							&& CharAffectingObject.checkFigured(power,
									getType()) && power.getAffectTotal()) {
						double mult = power.getIncreaseValue(getType(), true);
						doubleBase += mult; // / automaton;
						bonus += Rounder.roundHalfUp(mult); // / automaton);
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getTalents().size(); i++) {
			if (HeroDesigner.getActiveHero().getTalents().get(i) instanceof CombatLuck) {
				CombatLuck cl = (CombatLuck) HeroDesigner.getActiveHero()
						.getTalents().get(i);
				if (cl.getAffectPrimary() && cl.getAffectTotal()) {
					Rounder.roundHalfUp(bonus += cl.getPdIncrease()
							* (double) cl.getLevels()
							/ (double) cl.getPdIncreaseLevels());
				}
			}
		}
		primaryValue = bonus;

		primaryValueCalcTime = System.currentTimeMillis();
	}

	protected void calcResistantTotal(boolean primaryOnly) {
		double bonus = 0;
		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof Power) {
						Power power = (Power) cp.getPowers().get(j);
						if (power.getPdIncreaseLevels() > 0) {
							if (power.resistantDefenses()
									&& (power.getAffectPrimary() || !primaryOnly)
									&& power.getAffectTotal()) {
								bonus += Rounder.roundHalfUp(power
										.getPdIncrease()
										* (double) power.getLevels()
										/ (double) power.getPdIncreaseLevels());
							}
						}
					} else if (cp.getPowers().get(j) instanceof CombatLuck) {
						CombatLuck power = (CombatLuck) cp.getPowers().get(j);
						if (power.getPdIncreaseLevels() > 0) {
							if ((power.getAffectPrimary() || !primaryOnly)
									&& power.getAffectTotal()) {
								bonus += Rounder.roundHalfUp(power
										.getPdIncrease()
										* (double) power.getLevels()
										/ (double) power.getPdIncreaseLevels());
							}
						}
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof Power) {
				Power power = (Power) HeroDesigner.getActiveHero().getPowers()
						.get(i);
				if (power.getPdIncreaseLevels() > 0) {
					if (power.resistantDefenses()
							&& (power.getAffectPrimary() || !primaryOnly)
							&& power.getAffectTotal()) {
						bonus += Rounder.roundHalfUp(power.getPdIncrease()
								* (double) power.getLevels()
								/ (double) power.getPdIncreaseLevels());
					}
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CombatLuck) {
				CombatLuck power = (CombatLuck) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				if (power.getPdIncreaseLevels() > 0) {
					if ((power.getAffectPrimary() || !primaryOnly)
							&& power.getAffectTotal()) {
						bonus += Rounder.roundHalfUp(power.getPdIncrease()
								* (double) power.getLevels()
								/ (double) power.getPdIncreaseLevels());
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof Power) {
						Power power = (Power) cp.getPowers().get(j);
						if (power.getPdIncreaseLevels() > 0) {
							if (power.resistantDefenses()
									&& (power.getAffectPrimary() || !primaryOnly)
									&& power.getAffectTotal()) {
								bonus += Rounder.roundHalfUp(power
										.getPdIncrease()
										* (double) power.getLevels()
										/ (double) power.getPdIncreaseLevels());
							}
						}
					} else if (cp.getPowers().get(j) instanceof CombatLuck) {
						CombatLuck power = (CombatLuck) cp.getPowers().get(j);
						if (power.getPdIncreaseLevels() > 0) {
							if ((power.getAffectPrimary() || !primaryOnly)
									&& power.getAffectTotal()) {
								bonus += Rounder.roundHalfUp(power
										.getPdIncrease()
										* (double) power.getLevels()
										/ (double) power.getPdIncreaseLevels());
							}
						}
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof Power) {
				Power power = (Power) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				if (power.getPdIncreaseLevels() > 0) {
					if (power.resistantDefenses()
							&& (power.getAffectPrimary() || !primaryOnly)
							&& power.getAffectTotal()) {
						bonus += Rounder.roundHalfUp(power.getPdIncrease()
								* (double) power.getLevels()
								/ (double) power.getPdIncreaseLevels());
					}
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CombatLuck) {
				CombatLuck power = (CombatLuck) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				if (power.getPdIncreaseLevels() > 0) {
					if ((power.getAffectPrimary() || !primaryOnly)
							&& power.getAffectTotal()) {
						bonus += Rounder.roundHalfUp(power.getPdIncrease()
								* (double) power.getLevels()
								/ (double) power.getPdIncreaseLevels());
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getTalents().size(); i++) {
			if (HeroDesigner.getActiveHero().getTalents().get(i) instanceof CombatLuck) {
				CombatLuck cl = (CombatLuck) HeroDesigner.getActiveHero()
						.getTalents().get(i);
				if ((cl.getAffectPrimary() || !primaryOnly)
						&& cl.getAffectTotal()) {
					Rounder.roundHalfUp(bonus += cl.getPdIncrease()
							* (double) cl.getLevels()
							/ (double) cl.getPdIncreaseLevels());
				}
			}
		}
		int damageResistance = getPdResistance();
		int check = getNonresistantTotal(primaryOnly);
		if (damageResistance <= check) {
			bonus += damageResistance;
		} else if (check > 0) {
			bonus += check;
		}

		if (primaryOnly) {
			primaryResistantTotal = (int) Rounder.roundHalfUp(bonus);
			primaryResistantTotalCalcTime = System.currentTimeMillis();
		} else {
			secondaryResistantTotal = (int) Rounder.roundHalfUp(bonus);
			secondaryResistantTotalCalcTime = System.currentTimeMillis();
		}
	}

	@Override
	protected void calcSecondaryValue() {
		super.calcSecondaryValue();
		double ret = secondaryValue;
		for (int i = 0; i < HeroDesigner.getActiveHero().getTalents().size(); i++) {
			if (HeroDesigner.getActiveHero().getTalents().get(i) instanceof CombatLuck) {
				CombatLuck cl = (CombatLuck) HeroDesigner.getActiveHero()
						.getTalents().get(i);
				if (!cl.getAffectPrimary() && cl.getAffectTotal()) {
					ret += cl.getPdIncrease() * (double) cl.getLevels()
							/ (double) cl.getPdIncreaseLevels();
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
			if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CombatLuck) {
				CombatLuck cl = (CombatLuck) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				if (!cl.getAffectPrimary() && cl.getAffectTotal()) {
					ret += cl.getPdIncrease() * (double) cl.getLevels()
							/ (double) cl.getPdIncreaseLevels();
				}
			} else if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getPowers().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof CombatLuck) {
						CombatLuck cl = (CombatLuck) cp.getPowers().get(j);
						if (!cl.getAffectPrimary() && cl.getAffectTotal()) {
							ret += cl.getPdIncrease() * (double) cl.getLevels()
									/ (double) cl.getPdIncreaseLevels();
						}
					}
				}
			}
		}
		for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment().size(); i++) {
			if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CombatLuck) {
				CombatLuck cl = (CombatLuck) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				if (!cl.getAffectPrimary() && cl.getAffectTotal()) {
					ret += cl.getPdIncrease() * (double) cl.getLevels()
							/ (double) cl.getPdIncreaseLevels();
				}
			} else if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof CompoundPower) {
				CompoundPower cp = (CompoundPower) HeroDesigner.getActiveHero()
						.getEquipment().get(i);
				for (int j = 0; j < cp.getPowers().size(); j++) {
					if (cp.getPowers().get(j) instanceof CombatLuck) {
						CombatLuck cl = (CombatLuck) cp.getPowers().get(j);
						if (!cl.getAffectPrimary() && cl.getAffectTotal()) {
							ret += cl.getPdIncrease() * (double) cl.getLevels()
									/ (double) cl.getPdIncreaseLevels();
						}
					}
				}
			}
		}
		secondaryValue = ret;
		secondaryValueCalcTime = System.currentTimeMillis();
	}

	@Override
	public String getDisplayNotes() {
		int res1 = getResistantTotal(true);
		int res2 = getResistantTotal(false);
		int non1 = getNonresistantTotal(true);
		int non2 = getNonresistantTotal(false);

		String ret = non1 + "";
		if (non1 != non2) {
			ret += "/" + non2;
		}
		ret += " PD (" + res1;
		if (res1 != res2) {
			ret += "/" + res2;
		}
		ret += " rPD)";

		return ret;
	}

	public int getNonresistantTotal(boolean primaryOnly) {
		double bonus = 0;
		double val = bonus;
		if (primaryOnly) {
			val += getPrimaryValue();
		} else {
			val += getSecondaryValue();
		}
		if (val < maxVal) {
			return (int) Rounder.roundHalfUp(val);
		} else {
			return maxVal;
		}
	}

	public int getPdResistance() {
		if (pdResistanceCalcTime <= 0
				|| pdResistanceCalcTime < HeroDesigner.lastEdit) {
			calcPdResistance();
		}
		return pdResistance;
	}

	public int getResistantTotal(boolean primaryOnly) {
		if (primaryOnly) {
			if (primaryResistantTotalCalcTime <= 0
					|| primaryResistantTotalCalcTime < HeroDesigner.lastEdit) {
				calcResistantTotal(primaryOnly);
			}
			return primaryResistantTotal;
		}
		if (secondaryResistantTotalCalcTime <= 0
				|| secondaryResistantTotalCalcTime < HeroDesigner.lastEdit) {
			calcResistantTotal(primaryOnly);
		}
		return secondaryResistantTotal;
	}

	@Override
	public String getRoll() {
		return "";
	}

	@Override
	public int getType() {
		return Constants.PD;
	}
}